<?php

require_once 'vendor/autoload.php';

$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use Illuminate\Support\Facades\DB;

echo "🚀 Starting cleanup of Sales and Customer data...\n";
echo "⚠️  WARNING: This will permanently delete ALL sales and customer data!\n";
echo "Press Enter to continue or Ctrl+C to cancel: ";
$handle = fopen("php://stdin", "r");
$line = fgets($handle);
fclose($handle);

try {
    DB::beginTransaction();
    
    echo "\n📊 Current data counts before deletion:\n";
    $counts = [
        'invoices' => DB::table('invoices')->count(),
        'exchanges' => DB::table('exchanges')->count(), 
        'payments' => DB::table('payments')->count(),
        'customer_payments' => DB::table('customer_payments')->count(),
        'job_sheets' => DB::table('job_sheets')->count(),
        'sell_transactions' => DB::table('sell_transactions')->count(),
        'sales' => DB::table('sales')->count(),
        'customers' => DB::table('customers')->count(),
    ];
    
    foreach ($counts as $table => $count) {
        echo "  - {$table}: {$count} records\n";
    }
    
    echo "\n🗑️  Starting deletion process...\n";
    
    // Step 1: Delete invoices (depends on sales)
    echo "1. Deleting invoices...\n";
    $deleted = DB::table('invoices')->delete();
    echo "   ✅ Deleted {$deleted} invoice records\n";
    
    // Step 2: Delete exchanges (depends on sales)
    echo "2. Deleting exchanges...\n";
    $deleted = DB::table('exchanges')->delete();
    echo "   ✅ Deleted {$deleted} exchange records\n";
    
    // Step 3: Delete payments (depends on sales)
    echo "3. Deleting payments...\n";
    $deleted = DB::table('payments')->delete();
    echo "   ✅ Deleted {$deleted} payment records\n";
    
    // Step 4: Delete customer payments (depends on customers)
    echo "4. Deleting customer payments...\n";
    $deleted = DB::table('customer_payments')->delete();
    echo "   ✅ Deleted {$deleted} customer payment records\n";
    
    // Step 5: Delete job sheets (depends on customers)
    echo "5. Deleting job sheets...\n"; 
    $deleted = DB::table('job_sheets')->delete();
    echo "   ✅ Deleted {$deleted} job sheet records\n";
    
    // Step 6: Delete POS entries (if they reference sales)
    echo "6. Deleting POS entries...\n";
    $deleted = DB::table('pos')->delete();
    echo "   ✅ Deleted {$deleted} POS records\n";
    
    // Step 7: Delete direct sales entries
    echo "7. Deleting direct sales...\n";
    $deleted = DB::table('direct_sales')->delete();
    echo "   ✅ Deleted {$deleted} direct sales records\n";
    
    // Step 8: Delete sell transactions (depends on sales via foreign key)
    echo "8. Deleting sell transactions...\n";
    $deleted = DB::table('sell_transactions')->delete();
    echo "   ✅ Deleted {$deleted} sell transaction records\n";
    
    // Step 9: Delete sales (depends on customers)
    echo "9. Deleting sales...\n";
    $deleted = DB::table('sales')->delete();
    echo "   ✅ Deleted {$deleted} sales records\n";
    
    // Step 10: Finally delete customers (no dependencies)
    echo "10. Deleting customers...\n";
    $deleted = DB::table('customers')->delete();
    echo "   ✅ Deleted {$deleted} customer records\n";
    
    // Reset auto-increment counters
    echo "\n🔄 Resetting auto-increment counters...\n";
    $tables = ['invoices', 'exchanges', 'payments', 'customer_payments', 'job_sheets', 'pos', 'direct_sales', 'sell_transactions', 'sales', 'customers'];
    
    foreach ($tables as $table) {
        DB::statement("DELETE FROM sqlite_sequence WHERE name = '{$table}'");
        echo "   ✅ Reset {$table} auto-increment\n";
    }
    
    DB::commit();
    
    echo "\n🎉 SUCCESS! All sales and customer data has been deleted.\n";
    echo "📊 Final verification - Current counts:\n";
    
    $finalCounts = [
        'invoices' => DB::table('invoices')->count(),
        'exchanges' => DB::table('exchanges')->count(),
        'payments' => DB::table('payments')->count(), 
        'customer_payments' => DB::table('customer_payments')->count(),
        'job_sheets' => DB::table('job_sheets')->count(),
        'sell_transactions' => DB::table('sell_transactions')->count(),
        'sales' => DB::table('sales')->count(),
        'customers' => DB::table('customers')->count(),
    ];
    
    foreach ($finalCounts as $table => $count) {
        echo "  - {$table}: {$count} records\n";
    }
    
} catch (Exception $e) {
    DB::rollback();
    echo "\n❌ ERROR: " . $e->getMessage() . "\n";
    echo "Transaction rolled back. No data was deleted.\n";
    exit(1);
}

echo "\n✨ Cleanup completed successfully!\n";